% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ggplot}
\alias{ggplot}
\alias{ggplot.default}
\alias{ggplot.data.frame}
\alias{print.ggplot}
\alias{plot.ggplot}
\title{Create a new ggplot plot.}
\usage{
ggplot(data = NULL, mapping = aes(), ..., environment = parent.frame())

\method{print}{ggplot}(x, newpage = is.null(vp), vp = NULL, ...)

\method{plot}{ggplot}(x, newpage = is.null(vp), vp = NULL, ...)
}
\arguments{
\item{data}{Default dataset to use for plot. If not already a data.frame,
will be converted to one by \code{\link[ggplot2:fortify]{fortify()}}. If not specified,
must be supplied in each layer added to the plot.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{other arguments not used by this method}

\item{environment}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Used prior to tidy
evaluation.}

\item{x}{plot to display}

\item{newpage}{draw new (empty) page first?}

\item{vp}{viewport to draw plot in}
}
\value{
Invisibly returns the result of \code{\link{ggplot_build}}, which
  is a list with components that contain the plot itself, the data,
  information about the scales, panels etc.
}
\description{
\code{ggplot()} initializes a ggplot object. It can be used to
declare the input data frame for a graphic and to specify the
set of plot aesthetics intended to be common throughout all
subsequent layers unless specifically overridden.
}
\details{
\code{ggplot()} is typically used to construct a plot
incrementally, using the + operator to add layers to the
existing ggplot object. This is advantageous in that the
code is explicit about which layers are added and the order
in which they are added. For complex graphics with multiple
layers, initialization with \code{ggplot} is recommended.

There are three common ways to invoke \code{ggplot}:
\itemize{
   \item \code{ggplot(df, aes(x, y, <other aesthetics>))}
   \item \code{ggplot(df)}
   \item \code{ggplot()}
  }
The first method is recommended if all layers use the same
data and the same set of aesthetics, although this method
can also be used to add a layer using data from another
data frame. See the first example below. The second
method specifies the default data frame to use for the plot,
but no aesthetics are defined up front. This is useful when
one data frame is used predominantly as layers are added, 
but the aesthetics may vary from one layer to another. The
third method initializes a skeleton \code{ggplot} object which
is fleshed out as layers are added. This method is useful when
multiple data frames are used to produce different layers, as
is often the case in complex graphics.
}
\author{
Nicholas Hamilton
}
\keyword{hplot}
