% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales-tern.R
\name{scale_T_continuous}
\alias{scale_L_continuous}
\alias{scale_R_continuous}
\alias{scale_T_continuous}
\alias{scale_tern_continuous}
\title{Continuous position scales (T, L & R).}
\usage{
scale_T_continuous(name = waiver(), limits = c(0, 1),
  breaks = getBreaks(limits, TRUE), minor_breaks = getBreaks(limits, FALSE),
  labels = getLabels(breaks = breaks), expand = waiver(), ...)

scale_L_continuous(name = waiver(), limits = c(0, 1),
  breaks = getBreaks(limits, TRUE), minor_breaks = getBreaks(limits, FALSE),
  labels = getLabels(breaks = breaks), expand = waiver(), ...)

scale_R_continuous(name = waiver(), limits = c(0, 1),
  breaks = getBreaks(limits, TRUE), minor_breaks = getBreaks(limits, FALSE),
  labels = getLabels(breaks = breaks), expand = waiver(), ...)
}
\arguments{
\item{name}{The name of the scale. Used as axis or legend title. If
\code{NULL}, the default, the name of the scale is taken from the first
mapping used for that aesthetic.}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{breaks}{One of: \itemize{
  \item \code{NULL} for no breaks
  \item \code{waiver()} for the default breaks computed by the
    transformation object
  \item A numeric vector of positions
  \item A function that takes the limits as input and returns breaks
    as output
}}

\item{minor_breaks}{One of: \itemize{
  \item \code{NULL} for no minor breaks
  \item \code{waiver()} for the default breaks (one minor break between
    each major break)
  \item A numeric vector of positions
  \item A function that given the limits returns a vector of minor breaks.
}}

\item{labels}{One of: \itemize{
  \item \code{NULL} for no labels
  \item \code{waiver()} for the default labels computed by the
    transformation object
  \item A character vector giving labels (must be same length as \code{breaks})
  \item A function that takes the breaks as input and returns labels
    as output
}}

\item{expand}{A numeric vector of length two giving multiplicative and
additive expansion constants. These constants ensure that the data is
placed some distance away from the axes. The defaults are
\code{c(0.05, 0)} for continuous variables, and \code{c(0, 0.6)} for
discrete variables.}

\item{...}{not used}
}
\description{
Continuous position scales (T, L & R).
}

