% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-Xline.R
\docType{data}
\name{geom_Xline}
\alias{GeomLline}
\alias{GeomRline}
\alias{GeomTline}
\alias{Lline}
\alias{Rline}
\alias{Tline}
\alias{geom_Lline}
\alias{geom_Rline}
\alias{geom_Tline}
\alias{geom_Xline}
\alias{lline}
\alias{rline}
\alias{tline}
\title{Fixed Value Lines}
\usage{
geom_Tline(mapping = NULL, data = NULL, ..., Tintercept, na.rm = FALSE,
  show.legend = NA)

Tline(mapping = NULL, data = NULL, ..., Tintercept, na.rm = FALSE,
  show.legend = NA)

tline(mapping = NULL, data = NULL, ..., Tintercept, na.rm = FALSE,
  show.legend = NA)

geom_Lline(mapping = NULL, data = NULL, ..., Lintercept, na.rm = FALSE,
  show.legend = NA)

Lline(mapping = NULL, data = NULL, ..., Lintercept, na.rm = FALSE,
  show.legend = NA)

lline(mapping = NULL, data = NULL, ..., Lintercept, na.rm = FALSE,
  show.legend = NA)

geom_Rline(mapping = NULL, data = NULL, ..., Rintercept, na.rm = FALSE,
  show.legend = NA)

Rline(mapping = NULL, data = NULL, ..., Rintercept, na.rm = FALSE,
  show.legend = NA)

rline(mapping = NULL, data = NULL, ..., Rintercept, na.rm = FALSE,
  show.legend = NA)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{Tintercept, Lintercept, Rintercept}{the intercepts for the T, L and R axis respectively}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}
}
\description{
Plot fixed value lines, for the top, left and right axis, analagous to the \code{\link{geom_hline}}
and \code{\link{geom_vline}} geometries in \code{\link[=ggplot]{ggplot2}}
}
\examples{
ggtern() + 
geom_Tline(Tintercept=.5,arrow=arrow(), colour='red') + 
geom_Lline(Lintercept=.2, colour='green') + 
geom_Rline(Rintercept=.1, colour='blue')
}
\author{
Nicholas Hamilton
}
\keyword{datasets}

