% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbetweenstats.R
\name{ggbetweenstats}
\alias{ggbetweenstats}
\title{Box/Violin plots for group or condition comparisons in
between-subjects designs.}
\usage{
ggbetweenstats(
  data,
  x,
  y,
  plot.type = "boxviolin",
  type = "parametric",
  pairwise.comparisons = FALSE,
  pairwise.display = "significant",
  p.adjust.method = "holm",
  effsize.type = "unbiased",
  partial = TRUE,
  bf.prior = 0.707,
  bf.message = TRUE,
  results.subtitle = TRUE,
  xlab = NULL,
  ylab = NULL,
  caption = NULL,
  title = NULL,
  subtitle = NULL,
  sample.size.label = TRUE,
  k = 2,
  var.equal = FALSE,
  conf.level = 0.95,
  nboot = 100,
  tr = 0.1,
  mean.plotting = TRUE,
  mean.ci = FALSE,
  mean.point.args = list(size = 5, color = "darkred"),
  mean.label.args = list(size = 3),
  notch = FALSE,
  notchwidth = 0.5,
  linetype = "solid",
  outlier.tagging = FALSE,
  outlier.label = NULL,
  outlier.coef = 1.5,
  outlier.shape = 19,
  outlier.color = "black",
  outlier.label.args = list(size = 3),
  outlier.point.args = list(),
  point.args = list(position = ggplot2::position_jitterdodge(dodge.width = 0.6), alpha
    = 0.4, size = 3, stroke = 0),
  violin.args = list(width = 0.5, alpha = 0.2),
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  package = "RColorBrewer",
  palette = "Dark2",
  ggplot.component = NULL,
  output = "plot",
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{plot.type}{Character describing the \emph{type} of plot. Currently supported
plots are \code{"box"} (for pure boxplots), \code{"violin"} (for pure violin plots),
and \code{"boxviolin"} (for a combination of box and violin plots; default).}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{pairwise.comparisons}{Logical that decides whether pairwise comparisons
are to be displayed (default: \code{FALSE}). Please note that only
\strong{significant} comparisons will be shown by default. To change this
behavior, select appropriate option with \code{pairwise.display} argument. The
pairwise comparison dataframes are prepared using the
\code{pairwiseComparisons::pairwise_comparisons} function. For more details
about pairwise comparisons, see the documentation for that function.}

\item{pairwise.display}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (equivalent to \code{"d"} for Cohen's \emph{d} for
\strong{t-test}; \code{"partial_eta"} for partial eta-squared for \strong{anova}) or
\code{"unbiased"} (equivalent to \code{"g"} Hedge's \emph{g} for \strong{t-test};
\code{"partial_omega"} for partial omega-squared for \strong{anova})).}

\item{partial}{If \code{TRUE}, return partial indices.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{xlab, ylab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{caption}{The text for the plot caption.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{mean.plotting}{Logical that decides whether mean is to be highlighted
and its value to be displayed (Default: \code{TRUE}).}

\item{mean.ci}{Logical that decides whether \verb{95\%} confidence interval for
mean is to be displayed (Default: \code{FALSE}).}

\item{mean.point.args, mean.label.args}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms involved mean value plotting.}

\item{notch}{A logical. If \code{FALSE} (default), a standard box plot will be
displayed. If \code{TRUE}, a notched box plot will be used. Notches are used to
compare groups; if the notches of two boxes do not overlap, this suggests
that the medians are significantly different. In a notched box plot, the
notches extend \code{1.58 * IQR / sqrt(n)}. This gives a roughly \verb{95\%}
confidence interval for comparing medians. IQR: Inter-Quartile Range.}

\item{notchwidth}{For a notched box plot, width of the notch relative to the
body (default \code{0.5}).}

\item{linetype}{Character strings (\code{"blank"}, \code{"solid"}, \code{"dashed"},
\code{"dotted"}, \code{"dotdash"}, \code{"longdash"}, and \code{"twodash"}) specifying the type
of line to draw box plots (Default: \code{"solid"}). Alternatively, the numbers
\code{0} to \code{6} can be used (\code{0} for "blank", \code{1} for "solid", etc.).}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged. This
\strong{can't} be the same as \code{x} argument.}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{outlier.shape}{Hiding the outliers can be achieved by setting
\code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the \code{y}-axis will be
the same with outliers shown and outliers hidden.}

\item{outlier.color}{Default aesthetics for outliers (Default: \code{"black"}).}

\item{outlier.point.args, outlier.label.args}{A list of additional aesthetic arguments to be
passed to \code{ggplot2::geom_point} and \code{ggrepel::geom_label_repel} geoms
involved outlier value plotting.}

\item{point.args}{A list of additional aesthetic arguments to be passed to
the \code{geom_point} displaying the raw data.}

\item{violin.args}{A list of additional aesthetic arguments to be passed to
the \code{geom_violin}.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{Name of palette as string or symbol.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}. For functions
\code{ggpiestats} and \code{ggbarstats}, setting \code{output = "proptest"} will return a
dataframe containing results from proportion tests.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Currently ignored.}
}
\description{
A combination of box and violin plots along with jittered data
points for between-subjects designs with statistical details included in
the plot as a subtitle.
}
\details{
For parametric tests, Welch's ANOVA/\emph{t}-test are used as a default (i.e.,
\code{var.equal = FALSE}).
References:
\itemize{
\item ANOVA: Delacre, Leys, Mora, & Lakens, \emph{PsyArXiv}, 2018
\item \emph{t}-test: Delacre, Lakens, & Leys,
\emph{International Review of Social Psychology}, 2017
}

If robust tests are selected, following tests are used is .
\itemize{
\item ANOVA: one-way ANOVA on trimmed means (see \code{?WRS2::t1way})
\item \emph{t}-test: Yuen's test for trimmed means (see \code{?WRS2::yuen})
}

For more about how the effect size measures (for nonparametric tests) and
their confidence intervals are computed, see \code{?rcompanion::wilcoxonR}.

For repeated measures designs, use \code{ggwithinstats}.
}
\examples{
\donttest{
# to get reproducible results from bootstrapping
set.seed(123)
library(ggstatsplot)

# simple function call with the defaults
ggstatsplot::ggbetweenstats(
  data = mtcars,
  x = am,
  y = mpg,
  title = "Fuel efficiency by type of car transmission",
  caption = "Transmission (0 = automatic, 1 = manual)"
)

# more detailed function call
ggstatsplot::ggbetweenstats(
  data = datasets::morley,
  x = Expt,
  y = Speed,
  type = "nonparametric",
  plot.type = "box",
  conf.level = 0.99,
  xlab = "The experiment number",
  ylab = "Speed-of-light measurement",
  pairwise.comparisons = TRUE,
  p.adjust.method = "fdr",
  outlier.tagging = TRUE,
  outlier.label = Run,
  nboot = 10,
  ggtheme = ggplot2::theme_grey(),
  ggstatsplot.layer = FALSE
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggbetweenstats.html}
}
\seealso{
\code{\link{grouped_ggbetweenstats}}, \code{\link{ggwithinstats}},
\code{\link{grouped_ggwithinstats}}
}
