% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_anova_parametric}
\alias{subtitle_anova_parametric}
\title{Making text subtitle for the between-subject anova designs.}
\usage{
subtitle_anova_parametric(data, x, y, effsize.type = "unbiased",
  partial = TRUE, conf.level = 0.95, nboot = 100,
  var.equal = FALSE, k = 2, messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments.}
}
\description{
Making text subtitle for the between-subject anova designs.
}
\examples{
# with defaults
subtitle_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  k = 3
)

# modifying the defaults
subtitle_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  effsize.type = "biased",
  partial = FALSE,
  var.equal = TRUE,
  nboot = 10
)
}
\author{
Indrajeet Patil
}
