% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_graphics.R
\name{legend_title_margin}
\alias{legend_title_margin}
\title{Custom function to set upper and lower margins to legend title in
ggplot2}
\usage{
legend_title_margin(plot, t.margin = unit(0, "mm"), b.margin = unit(3,
  "mm"))
}
\arguments{
\item{plot}{Plot with the legend title whose margins need to be modified.}

\item{t.margin, b.margin}{Margins in grid units.}
}
\value{
A plot with desired margins between the legend title and the legend.
}
\description{
Custom function to set upper and lower margins to legend title in
ggplot2
}
\note{
This is a helper function used internally in the package and not
exported. In case you want to use it, you can do so by
\code{ggstatsplot:::legend_title_margin}. Note that it is \code{:::} and not \code{::}.
}
\references{
https://stackoverflow.com/questions/39247025/increase-space-between-legend-title-and-labels-in-ggplot2
}
\keyword{internal}
