% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{theme_stackplot}
\alias{theme_stackplot}
\title{Recommended base theme for stacked gg plots}
\usage{
theme_stackplot()
}
\value{
\code{\link[ggplot2:theme]{ggplot2::theme()}} object
}
\description{
Returns a basic ggplot2 theme that extends \code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}} with a transparent plot background to make sure overlapping plots do not cover each other up.
}
\examples{
library(ggplot2)
template <- ggplot() + geom_line() + theme_stackplot()

ggstackplot(
  data = mtcars,
  x = mpg, y = c(wt, qsec, drat),
  color = c("#E41A1C", "#377EB8", "#4DAF4A"),
  template = template
)

}
