% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{scale_y_Rfr_specular_continuous}
\alias{scale_y_Rfr_specular_continuous}
\alias{scale_y_Rfr_total_continuous}
\title{Reflectance y-scale}
\usage{
scale_y_Rfr_specular_continuous(unit.exponent = 0,
  name = Rfr_specular_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)

scale_y_Rfr_total_continuous(unit.exponent = 0,
  name = Rfr_total_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for spectral transmittance.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{
library(ggplot2)
library(photobiology)

ggplot(yellow_gel.spct) +
  geom_line() +
  scale_y_Rfr_total_continuous() +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct) +
  geom_line() +
  scale_y_Rfr_total_continuous(-2) +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct) +
  geom_line() +
  scale_y_Rfr_total_continuous(-3) +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct) +
  geom_line() +
  scale_y_Rfr_total_continuous() +
  scale_x_wl_continuous()

}
