% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-response-spct.R
\name{plot.response_spct}
\alias{plot.response_spct}
\title{Plot method for response spectra.}
\usage{
\method{plot}{response_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  pc.out = FALSE, label.qty = NULL, span = NULL, annotations = NULL,
  norm = "max", text.size = 2.5, na.rm = TRUE)
}
\arguments{
\item{x}{a response_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{unit.out}{character string indicating type of radiation units to use
for plotting: "photon" or its synomin "quantum", or "energy"}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
response_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\examples{
library(photobiology)
plot(photodiode.spct)
plot(photodiode.spct, unit.out = "photon")


}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}
