% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensions.R
\name{make_pitch_tracab}
\alias{make_pitch_tracab}
\title{Create Tracab dimensions object from pitch length and width}
\usage{
make_pitch_tracab(length = 105, width = 68)
}
\arguments{
\item{length}{Length of the pitch in metres}

\item{width}{Width of the pitch in metres}
}
\value{
A named list of pitch marking coordinates.
}
\description{
When the actual length and width of a pitch are known,
for example from Tracab file metadata, \code{make_pitch_tracab} can be
used to replace the 105m x 68m defaults hardcoded in \code{pitch_tracab}.
The remaining pitch markings are taken from the
UEFA Category 4 standard (\code{pitch_international}).
}
\examples{
library(ggplot2)
library(ggsoccer)

ggplot() +
  annotate_pitch(dimensions = make_pitch_tracab(110, 70)) +
  theme_pitch()


}
\seealso{
\code{pitch_tracab}
}
