% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_graph.R
\name{plot_time_series}
\alias{plot_time_series}
\title{Plot line graph showing parameter value vs dimension from algorithm output.}
\usage{
plot_time_series(
  output,
  parameters,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  max_line_width = 1,
  alpha = 0.1,
  xlimits = NULL,
  ylimits = NULL
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameters}{The parameters we wish to be on the y-axis of the line graph.}

\item{target}{(optional) The target to plot. (default is to use all targets)}

\item{external_target}{(optional) The external target to plot. (default is to use all external targets, or to ignore if the column is not present)}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the line graph. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{max_line_width}{(optional) The maximum size of the points in the plot. (default=1)}

\item{alpha}{(optional) The transparency of the lines in the plot. (default=0.1)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}
}
\value{
A line graph in a ggplot figure.
}
\description{
Plot line graph showing parameter value vs dimension from algorithm output.
}
