% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_freesurfer.R
\name{read_freesurfer_table}
\alias{read_freesurfer_table}
\title{Read in stats table from Freesurfer}
\usage{
read_freesurfer_table(path, measure = NULL, ...)
}
\arguments{
\item{path}{path to the table file}

\item{measure}{which measure is the table of}

\item{...}{additional arguments to \code{read.table}}
}
\value{
tibble with stats information for subjects from FreeSurfer
}
\description{
Freesurfer has functions to create
tables from raw stats files. If you have
data already merged using the \code{aparcstats2table}
or \code{asegstats2table} from Freesurfer,
this function will read in the data and prepare it
for ggseg.
}
\examples{
\dontrun{
file_path <- "all_subj_aseg.txt"
read_freesurfer_table(file_path)
}
}
