% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_waist.r
\name{scale_waist_continuous}
\alias{scale_waist_continuous}
\alias{scale_waist_datetime}
\alias{scale_waist_binned}
\alias{scale_waist_discrete}
\alias{scale_waist_manual}
\alias{scale_waist_identity}
\title{Sankey edge waist line scales}
\usage{
scale_waist_continuous(..., range = c(0, 1))

scale_waist_datetime(..., range = c(0, 1))

scale_waist_binned(..., range = c(0, 1))

scale_waist_discrete(..., range = c(0, 1))

scale_waist_manual(..., values = NULL, breaks = ggplot2::waiver())

scale_waist_identity(..., guide = "none")
}
\arguments{
\item{...}{arguments passed onto underpinning scale constructors.}

\item{range}{A \code{vector} of two \code{numeric} values used to scale the waist in between.
Should be \verb{>= 0}.}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{guide}{Guide to use for this scale. Defaults to \code{"none"}.}
}
\value{
Returns a \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object which can be added to a \link[ggplot2:ggplot]{ggplot2::ggplot} to
control the waist of Sankey diagram edges.
}
\description{
The waist scale can be used to control the waist (i.e., the width of the edge at its centre)
of edges in Sankey diagrams, in order to put emphasis on specific edges.
}
\details{
This scale can be used to scale the centre of a Sankey edge. At one end of the scale
the edge will be shaped like an hour glass, at the other end it will be shaped as an
apple.
}
\examples{
library(ggplot2)
data("ecosystem_services")

p <-
  ggplot(ecosystem_services_pivot2, aes(x = stage, y = RCSES, group = node,
                                        connector = connector, edge_id = edge_id,
                                        waist = RCSES)) +
  geom_sankeynode(v_space = "auto") +
  geom_sankeyedge(v_space = "auto", aes(fill = service_section))

p + scale_waist_binned(range = c(0.1, 2))
p + scale_waist_binned(range = c(2, 0.1))
}
\author{
Pepijn de Vries
}
