% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.r
\docType{data}
\name{PositionSankey}
\alias{PositionSankey}
\alias{position_sankey}
\title{Position nodes and edges in a Sankey diagram}
\format{
An object of class \code{PositionSankey} (inherits from \code{Position}, \code{ggproto}, \code{gg}) of length 13.
}
\usage{
PositionSankey

position_sankey(
  width = "auto",
  align = c("bottom", "top", "center", "justify"),
  order = c("ascending", "descending", "as_is"),
  h_space = "auto",
  v_space = 0,
  nudge_x = 0,
  nudge_y = 0,
  split_nodes = FALSE,
  split_tol = 0.001,
  direction = c("forward", "backward"),
  ...
)
}
\arguments{
\item{width}{Width of the node (\code{numeric}). When \code{split_nodes} is set to \code{TRUE}
each part of the split node will have half this width. Use \code{"auto"} to automatically
determine a suitable width.}

\item{align}{A \code{character} that indicates how the nodes across the stages are aligned.
It can be any of \code{"top"}, \code{"bottom"}, \code{"center"} or \code{"justify"}.}

\item{order}{A \code{character} indicating the method to be used for the order of stacking
nodes and edges in a plot.
Should be one of: \code{ascending} (default), sorts nodes and edges from large to small
(largest on top); \code{descending} sorts nodes and edges from small to large (smallest
on top); \code{as_is} will leave the order of nodes and edges as they are in \code{data}.}

\item{h_space}{Horizontal space between split nodes (\code{numeric}). This argument is
ignored when \code{split_nodes == FALSE}. Use \code{"auto"} to automatically position split nodes.}

\item{v_space}{Vertical space between nodes (\code{numeric}). When set to zero (\code{0}),
the Sankey diagram becomes an alluvial plot. Use \code{"auto"} to automatically determine
a suitable vertical space.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge items by. Can
be useful for offsetting labels.}

\item{split_nodes}{A \code{logical} value indicating whether the source and destination nodes
should be depicted as separate boxes.}

\item{split_tol}{When the relative node size (resulting source and destination edges)
differs more than this fraction, the node will be displayed as two separate bars.}

\item{direction}{One of \code{"forward"} (default) or \code{"backward"}. When set to \code{"backward"}
the direction of the edges will be inverted. In most cases this
parameter won't affect the plot. It can be helpful when you want to decorate the
end of an edge (instead of the start; see examples).}

\item{...}{Arguments passed on to \code{\link[ggplot2:ggproto]{ggplot2::ggproto()}}.}
}
\value{
Returns a \code{\link[ggplot2:ggplot2-ggproto]{ggplot2::Position}} class object.
}
\description{
Calculates the \code{x} and \code{y} positions of elements (nodes and edges) in a
Sankey diagram.
}
\details{
Based on the \verb{stat_*} function applied to the parent's (\code{\link[=stat_sankeynode]{stat_sankeynode()}},
\code{\link{stat_sankeyedge}}) object either node or edge positions are calculated respectively.
These positions can be used to add additional layers (e.g., text or labels) to the
plot.
}
\examples{
library(ggplot2)
data("ecosystem_services")

pos  <- position_sankey(v_space = "auto", order = "ascending")
pos2 <- position_sankey(v_space = "auto", order = "ascending", direction = "backward")

## Let's subset the data, to make the plot less cluttered:
es_subset <- pivot_stages_longer(
  subset(ecosystem_services, RCSES > 0.01),
  c("activity_realm", "biotic_realm", "service_section"),
  "RCSES",
  "service_section"
)


plot <-
  ggplot(es_subset, aes(x = stage, y = RCSES, group = node,
                                    connector = connector, edge_id = edge_id,
                                    fill = node)) +
  geom_sankeynode(position = pos) +
  geom_sankeyedge(position = pos, aes(fill = service_section))

# position labels at nodes
plot + geom_text(aes(label = node), stat = "sankeynode", position = pos)
# position labels at the start of edges
plot + geom_text(aes(label = sprintf("\%0.2f", RCSES)), stat = "sankeyedge", position = pos)
# position labels at the end of edges
plot + geom_text(aes(label = sprintf("\%0.2f", RCSES)), stat = "sankeyedge", position = pos2)
}
\author{
Pepijn de Vries
}
\keyword{datasets}
