% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmatL.R
\name{qmatL}
\alias{qmatL}
\title{Matrix \strong{Q} for large pedigrees}
\usage{
qmatL(ped2)
}
\arguments{
\item{ped2}{: The output \code{data.frame} from \code{gghead} (for more details: \code{?gghead})}
}
\value{
\strong{Q} \code{matrix}
}
\description{
Creates the genetic group contribution matrix for large pedigrees.
}
\details{
Calculation of the genetic group contribution matrix for large pedigrees requires a lot of memory and time.
This might not be possible on ordinary computers, using the function \code{qmat}.
The function \code{qmatL} takes less RAM and time, making the calculation possible for ordinary computers.
}
\examples{
ped = data.frame(ID=c(3,4,6,5), SIRE=c(1,3,4,1), DAM=c(2,2,5,2))
ped2 = gghead(ped)
qmatL(ped2)

}
