% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\docType{data}
\name{position_raincloud}
\alias{position_raincloud}
\alias{PositionRaincloud}
\title{Create a cloud of randomly jittered points below a ridgeline plot}
\usage{
position_raincloud(width = 0, height = 0.4, ygap = 0.05,
  adjust_vlines = FALSE, seed = NULL)
}
\arguments{
\item{width}{Width for horizonal jittering. By default set to 0.}

\item{height}{Total height of point cloud. By default 0.4.}

\item{ygap}{Vertical gap between ridgeline baseline and point cloud.}

\item{adjust_vlines}{If \code{TRUE}, adjusts vertical lines (as are drawn for
quantile lines, for example) to align with the point cloud.}

\item{seed}{Random seed. See \code{\link{position_points_jitter}}.}
}
\description{
This is a position adjustment specifically for \code{\link[=geom_density_ridges]{geom_density_ridges()}} and related geoms. It
only jitters the points drawn by these geoms, if any. If no points are present, the plot
remains unchanged. The effect is similar to \code{\link[=position_points_jitter]{position_points_jitter()}}, only that by default the
points lie all underneath the baseline of each individual ridgeline.
}
\examples{
library(ggplot2)

ggplot(iris, aes(x = Sepal.Length, y = Species)) +
  geom_density_ridges(jittered_points = TRUE, position = "raincloud", alpha = 0.7)
}
\seealso{
Other position adjustments for ridgeline plots: \code{\link{position_points_jitter}}, \code{\link{position_points_sina}}
}
\keyword{datasets}
