% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_district.R
\docType{data}
\name{geom_district}
\alias{geom_district}
\alias{stat_district}
\alias{StatDistrict}
\alias{GeomDistrict}
\title{Aggregate and Plot Map Regions}
\usage{
geom_district(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  is_coverage = FALSE,
  min_col = FALSE,
  buffer = 0,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_district(
  mapping = NULL,
  data = NULL,
  geom = GeomDistrict,
  position = "identity",
  na.rm = FALSE,
  is_coverage = FALSE,
  min_col = FALSE,
  buffer = 0,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{data}{The data to be displayed in this layer}

\item{position}{Position adjustment}

\item{na.rm}{if \code{TRUE}, will silently remove missing values from calculations}

\item{is_coverage}{As in \code{\link[sf:geos_combine]{sf::st_union()}}. May speed up plotting for large
shapefiles if \code{geos} is not installed or the shapefile is not projected.}

\item{min_col}{If \code{TRUE}, try to minimize the number of colors used. May
be necessary for short palettes.}

\item{buffer}{Optionally buffer the merged geometries. Negative values will
shrink geometries towards the center and can be used for a "glowing
boundary" effect (see examples).}

\item{show.legend}{Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{...}{Passed onto the underlying geoms.}

\item{geom}{The geometric object to use display the data}
}
\value{
a \code{ggproto} object
}
\description{
Aggregates shapefile according to the \code{group} aesthetic. If just \code{group} is
provided, then by default map regions will be colored by \code{group} so that
adjacent regions do not share a color (set \code{fill} to force a particular
color, or \code{NA} for no fill).  If \code{fill} is provided, the values in \code{fill}
will be summed within the groups defined by \code{group}. If \code{denom} is provided,
the values in \code{denom} will be summed within the groups defined by \code{group},
and then used to divide the summed values of \code{fill}. For example, \code{fill} and
\code{denom} can be used together to plot the partisan or demographic
characteristics congressional districts (see examples).
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(group=county)) +
    geom_district() +
    scale_fill_penn82() +
    theme_map()

ggplot(oregon, aes(group=county, fill=pop)) +
    geom_district() +
    theme_map()

ggplot(oregon, aes(group=cd_2020, fill=ndv, denom=ndv+nrv)) +
    geom_district() +
    scale_fill_party_c(limits=c(0.4, 0.6)) +
    theme_map()

ggplot(oregon, aes(group=county)) +
    geom_district() +
    geom_district(buffer=-5000, fill="#ffffffcc", color=NA) +
    scale_fill_natgeo() +
    theme_map()

}
\concept{geoms}
\keyword{datasets}
