% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fail_safe_formula}
\alias{fail_safe_formula}
\title{Safely extract the formula from an object}
\usage{
fail_safe_formula(fm, method.args = list(), verbose = TRUE)
}
\arguments{
\item{fm}{Fitted model object or a call object.}

\item{method.args}{List of arguments to check for the formula.}

\item{verbose}{logical If \code{TRUE} message triggered if call to
\code{formula()} fails.}
}
\value{
A named list with objects of class formula or NA as member(s).
}
\description{
Safely extract the formula from an object
}
\details{
Method \code{\link{formula}} is not implemented for all fitted
  model objects, while the default method triggers an error and stops
  exectution. Function \code{fail_safe_formula()} wraps the call to
  \code{formula()} and handles the error conditions by attempting to
  extract the formula from a list of arguments. If this fails, it returns
  \code{NA}, with a message.
}
\keyword{internal}
