##' convert a plot to grob object
##'
##'
##' @title as.grob
##' @param plot base or grid plot, or graphic object generated by ggplot, lattice, etc.
##' @return grob object
##' @export
##' @importFrom ggplot2 ggplotGrob
##' @importFrom rvcheck get_fun_from_pkg
##' @examples
##' as.grob(~barplot(1:10))
##' @author guangchuang yu
as.grob <- function(plot) {
    ## plot_expr <- quo_name(enexpr(plot))
    if (inherits(plot, "expression") ||
        inherits(plot, "formula") ||
        inherits(plot, "function")) {

        p <- tryCatch(base2grob(plot),
                      error = function(e) NULL)

        if (is.null(p)) {
            p <- grid::grid.grabExpr(plot_fun(plot)(), warn=0)
        }

        return(p)
    }

    if (inherits(plot, "ggplot")) {
        p <- ggplotGrob(plot)
    } else if (inherits(plot, "meme")) {
        memeGrob <- get_fun_from_pkg("meme", "memeGrob")
        p <- memeGrob(plot)
    } else if (inherits(plot, "trellis") ||
               inherits(plot, "upset")) {
        p <- grid::grid.grabExpr(print(plot))
    } else if (inherits(plot, "grob")) {
        p <- plot
    } else {
        message("fail to convert ...")
        return(NULL)
        ## p <- grid::grid.grabExpr(parse(text = plot_expr), warn=0)
    }

    return(p)
}

##' convert base plot to grob object
##'
##'
##' @title base2grob
##' @param x expression or formula of base plot function call, e.g. expression(pie(1:5)) or ~plot(1:10, 1:10);
##' or a function that plots to an R graphics device when called, e.g. function() plot(sqrt)
##' @return grob object
##' @importFrom gridGraphics grid.echo
##' @importFrom grid grid.grabExpr
##' @export
##' @examples
##' base2grob(~plot(rnorm(10)))
##' @author Guangchuang Yu
base2grob <- function(x) {
    old.par=par(no.readonly=TRUE)
    on.exit(suppressWarnings(par(old.par, no.readonly=TRUE)))

    grid.grabExpr(grid.echo(plot_fun(x)), warn=0)
}


