% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-secondary.R
\name{sec_axis}
\alias{derive}
\alias{dup_axis}
\alias{sec_axis}
\title{Specify a secondary axis}
\usage{
sec_axis(trans = NULL, name = waiver(), breaks = waiver(),
  labels = waiver())

dup_axis(trans = ~., name = derive(), breaks = derive(),
  labels = derive())

derive()
}
\arguments{
\item{trans}{A transformation formula}

\item{name}{The name of the secondary axis}

\item{breaks}{One of:
\itemize{
  \item{\code{NULL} for no breaks}
  \item{\code{waiver()} for the default breaks computed by the transformation object}
  \item{A numeric vector of positions}
  \item{A function that takes the limits as input and returns breaks as output}
}}

\item{labels}{One of:
\itemize{
  \item{\code{NULL} for no labels}
  \item{\code{waiver()} for the default labels computed by the transformation object}
  \item{A character vector giving labels (must be same length as \code{breaks})}
  \item{A function that takes the breaks as input and returns labels as output}
}}
}
\description{
This function is used in conjunction with a position scale to create a
secondary axis, positioned opposite of the primary axis. All secondary
axes must be based on a one-to-one transformation of the primary axes.
}
\details{
\code{sec_axis} is used to create the specifications for a secondary axis.
Except for the \code{trans} argument any of the arguments can be set to
\code{derive()} which would result in the secondary axis inheriting the
settings from the primary axis.

\code{dup_axis} is provide as a shorthand for creating a secondary axis that
is a duplication of the primary axis, effectively mirroring the primary axis.
}
\examples{
p <- ggplot(mtcars, aes(cyl, mpg)) +
  geom_point()

# Create a simple secondary axis
p + scale_y_continuous(sec.axis = sec_axis(~.+10))

# Inherit the name from the primary axis
p + scale_y_continuous("Miles/gallon", sec.axis = sec_axis(~.+10, name = derive()))

# Duplicate the primary axis
p + scale_y_continuous(sec.axis = dup_axis())

# You can pass in a formula as a shorthand
p + scale_y_continuous(sec.axis = ~.^2)

}

