\name{qplot}
\alias{qplot}
\alias{quickplot}
\title{Quick plot}
\usage{
  qplot(x, y = NULL, ..., data, facets = NULL,
    margins = FALSE, geom = "auto", stat = list(NULL),
    position = list(NULL), xlim = c(NA, NA),
    ylim = c(NA, NA), log = "", main = NULL,
    xlab = deparse(substitute(x)),
    ylab = deparse(substitute(y)), asp = NA)
}
\arguments{
  \item{x}{x values}

  \item{y}{y values}

  \item{...}{other aesthetics passed for each layer}

  \item{data}{data frame to use (optional).  If not
  specified, will create one, extracting vectors from the
  current environment.}

  \item{facets}{faceting formula to use.  Picks
  \code{\link{facet_wrap}} or \code{\link{facet_grid}}
  depending on whether the formula is one sided or
  two-sided}

  \item{margins}{whether or not margins will be displayed}

  \item{geom}{character vector specifying geom to use.
  Defaults to "point" if x and y are specified, and
  "histogram" is on x is specified.}

  \item{stat}{character vector specifying statistics to
  use}

  \item{position}{character vector giving position
  adjustment to use}

  \item{xlim}{limits for x axis}

  \item{ylim}{limits for y axis}

  \item{log}{which variables to log transform ("x", "y", or
  "xy")}

  \item{main}{character vector or expression for plot
  title}

  \item{xlab}{character vector or expression for x axis
  label}

  \item{ylab}{character vector or expression for y axis
  label}

  \item{asp}{the y/x aspect ratio}
}
\description{
  \code{qplot} is the basic plotting function in the
  ggplot2 package, designed to be familiar if you're used
  to \code{\link{plot}} from the base package. It is a
  convenient wrapper for creating a number of different
  types of plots using a consistent calling scheme. See
  \url{http://had.co.nz/ggplot2/book/qplot.pdf} for the
  chapter in the \code{ggplot2} book which describes the
  usage of \code{qplot} in detail.
}
\examples{
\donttest{
# Use data from data.frame
qplot(mpg, wt, data=mtcars)
qplot(mpg, wt, data=mtcars, colour=cyl)
qplot(mpg, wt, data=mtcars, size=cyl)
qplot(mpg, wt, data=mtcars, facets=vs ~ am)

# It will use data from local environment
hp <- mtcars$hp
wt <- mtcars$wt
cyl <- mtcars$cyl
vs <- mtcars$vs
am <- mtcars$am
qplot(hp, wt)
qplot(hp, wt, colour=cyl)
qplot(hp, wt, size=cyl)
qplot(hp, wt, facets=vs ~ am)

qplot(1:10, rnorm(10), colour = runif(10))
qplot(1:10, letters[1:10])
mod <- lm(mpg ~ wt, data=mtcars)
qplot(resid(mod), fitted(mod))
qplot(resid(mod), fitted(mod), facets = . ~ vs)

f <- function() {
   a <- 1:10
   b <- a ^ 2
   qplot(a, b)
}
f()

# qplot will attempt to guess what geom you want depending on the input
# both x and y supplied = scatterplot
qplot(mpg, wt, data = mtcars)
# just x supplied = histogram
qplot(mpg, data = mtcars)
# just y supplied = scatterplot, with x = seq_along(y)
qplot(y = mpg, data = mtcars)

# Use different geoms
qplot(mpg, wt, data = mtcars, geom="path")
qplot(factor(cyl), wt, data = mtcars, geom=c("boxplot", "jitter"))
}
}

