\name{stat_sum}
\alias{stat_sum}
\alias{StatSum}
\title{stat\_sum}
\description{Sum unique values.  Useful for overplotting on scatterplots}
\details{
This page describes stat\_sum, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with stat\_sum.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{stat\_sum(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{y}: y position (\strong{required}) 
  \item \code{size}: size 
}
}
\usage{stat_sum(mapping=NULL, data=NULL, geom="point", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{geom}{geometric used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \code{\link{ggfluctuation}}: Fluctuation diagram, which is very similar
  \item \url{http://had.co.nz/ggplot2/stat_sum.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
d <- ggplot(diamonds, aes(x = cut, y = clarity))
# Need to control which group proportion calculated over
# Overall proportion
d + stat_sum(aes(group = 1))
d + stat_sum(aes(group = 1)) + scale_size(to = c(3, 10))
d + stat_sum(aes(group = 1)) + scale_area(to = c(3, 10))
# by cut
d + stat_sum(aes(group = cut))
d + stat_sum(aes(group = clarity, colour = cut))
# by clarity
d + stat_sum(aes(group = clarity))
d + stat_sum(aes(group = clarity, colour = clarity))

# Instead of proportions, can also use sums
d + stat_sum(aes(size = ..n..))

# Can also weight by another variable
d + stat_sum(aes(group = 1, weight = price))
d + stat_sum(aes(group = 1, weight = price, size = ..n..))

# Or using qplot
qplot(cut, clarity, data = diamonds)
qplot(cut, clarity, data = diamonds, stat = "sum", group = 1)    
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
