% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggs_traceplot.R
\name{ggs_traceplot}
\alias{ggs_traceplot}
\title{Traceplot of the chains}
\usage{
ggs_traceplot(D, family = NA, original_burnin = TRUE,
  original_thin = TRUE, simplify = NULL)
}
\arguments{
\item{D}{Data frame with the simulations.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{original_burnin}{Logical. When TRUE (the default) start the Iteration counter in the x-axis at the end of the burnin period.}

\item{original_thin}{Logical. When TRUE (the default) take into account the thinning interval in the x-axis.}

\item{simplify}{Numerical. A percentage of iterations to keep in the time series. It is an option intended only for the purpose of saving time and resources when doing traceplots. It is not a thin operation, because it is not regular. It must be used with care.}
}
\value{
A \code{ggplot} object.
}
\description{
Traceplot with the time series of the chains.
}
\examples{
data(linear)
ggs_traceplot(ggs(s))
}

