% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{extract}
\alias{extract}
\title{Extract the nth element from vectors in a list.}
\usage{
extract(lst, num = min(lengths(lst)))
}
\arguments{
\item{lst}{A list of vectors of equal length, a data frame, or a matrix.
If the length of the smallest vector in \code{lst} is smaller than
\code{num} then an error will be thrown (\code{subscript out of bounds}).}

\item{num}{A number (preferably the length of the vectors) to create a
sequence for \code{extract()} to extract the elements of \code{lst}. Default
value is the length of the shortest vector in the list.}
}
\description{
\code{extract()} simply uses a \code{for} loop to extract the nth element
from each vector in a list. However, it can also operate on a data frame.
This is equivalent to taking the first element of each vector and making a
those elements the first vector in a new list, and it continues on so until
it reaches the last element.
}

