% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabet.r
\name{createPolygons}
\alias{createPolygons}
\title{Create a data set of polygons for a set of letters from a specified fontfamily}
\usage{
createPolygons(letters, font, fontsize = 400, dim = c(720, 720),
  scale = FALSE)
}
\arguments{
\item{letters}{set of characters for which polygons are to be created}

\item{font}{character describing the name of a font - use fonts() from package extrafont to check on available fonts}

\item{fontsize}{size of letter to be created - larger means higher resolution, but also bigger result sets}

\item{dim}{dimensions of the box in which the created letter is supposed to fit}

\item{scale}{scale the values along the y axis to use result in geom_logo}
}
\value{
data set compatible to work with geom_logo
}
\description{
Create a data set of polygons for a set of letters from a specified fontfamily
}
\examples{
\donttest{
# check that all letters and digits are nicely shaped:
new_alphabet <- createPolygons(c("f", "g", "W", "*"), font="Garamond")

library(ggplot2)
qplot(x,y, geom="polygon", data=new_alphabet, facets=~group)
}
}
