% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_hline_interactive.R
\name{geom_hline_interactive}
\alias{geom_hline_interactive}
\title{Horizontal interactive reference line}
\usage{
geom_hline_interactive(mapping = NULL, data = NULL, ..., yintercept,
  na.rm = FALSE, show.legend = NA)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}

\item{yintercept}{controls the position of the line}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_hline}}.
See the documentation for those functions for more details.
}
\examples{
# add interactive reference lines to a ggplot -------
library(ggplot2)

if( requireNamespace("dplyr", quietly = TRUE)){
  g1 <- ggplot(economics, aes(x = date, y = unemploy)) +
    geom_point() + geom_line()

  gg_hline1 <- g1 + geom_hline_interactive(
    aes(yintercept = mean(unemploy),
        tooltip = round(mean(unemploy), 2)))
  girafe(ggobj = gg_hline1)
}

dataset <- data.frame(
  x = c(1, 2, 5, 6, 8),
  y = c(3, 6, 2, 8, 7),
  vx = c(1, 1.5, 0.8, 0.5, 1.3),
  vy = c(0.2, 1.3, 1.7, 0.8, 1.4),
  year = c(2014, 2015, 2016, 2017, 2018)
)

dataset$clickjs <- rep(paste0("alert(\\"", mean(dataset$y), "\\")"), 5)


g2 <- ggplot(dataset, aes(x = year, y = y)) +
  geom_point() + geom_line()

gg_hline2 <- g2 + geom_hline_interactive(
  aes(yintercept = mean(y),
      tooltip = round(mean(y), 2),
      data_id = y, onclick = clickjs))


girafe(ggobj = gg_hline2)
}
\seealso{
\code{\link{ggiraph}}
}
