% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geom_rect_img}
\alias{geom_rect_img}
\alias{GeomRectImage}
\title{Display Images from Bounding Boxes}
\format{An object of class \code{GeomRectImage} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.}
\usage{
geom_rect_img(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  interpolate = TRUE
)

GeomRectImage
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by [aes()] or
[aes_()]. If specified and `inherit.aes = TRUE` (the
default), it is combined with the default mapping at the
top level of the plot. You must supply `mapping` if there
is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
                    options:

                    If `NULL`, the default, the data is inherited from the
                    plot data as specified in the call to [ggplot()].

                    A `data.frame`, or other object, will override the plot
                    data. All objects will be fortified to produce a data
                    frame.

                    A `function` will be called with a single argument,
                    the plot data. The return value must be a `data.frame`,
                    and will be used as the layer data. A `function` can be
                    created from a `formula` (e.g. `~ head(.x, 10)`).}

\item{stat}{The statistical transformation to use on the data for
this layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
`NA`, the default, includes if any aesthetics are mapped.
`FALSE` never includes, and `TRUE` always includes.
It can also be a named logical vector to finely select
the aesthetics to display.}

\item{inherit.aes}{If `FALSE`, overrides the default aesthetics,
rather than combining with them. This is most useful for
helper functions that define both data and aesthetics
and shouldn't inherit behaviour from the default plot
specification, e.g. [borders()].}

\item{...}{Other arguments passed on to [layer()]. These are often
aesthetics, used to set an aesthetic to a fixed value.}

\item{interpolate}{A logical value indicating whether to linearly
interpolate the image (the alternative is to use
nearest-neighbour interpolation, which gives a more
blocky result).}
}
\description{
Display Images from Bounding Boxes
}
\examples{

library(ggplot2)
posters$path <- file.path(
  system.file("extdata", package="ggimg"), posters$img
)
p_paths <- ggplot(posters) +
 geom_rect_img(aes(
    xmin = year - 0.5,
    xmax = year + 0.5,
    ymin = stars - 0.5,
    ymax = stars + 0.5,
    img = path
  ))


}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
