% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_wrap2.R
\name{facet_wrap2}
\alias{facet_wrap2}
\title{Extended wrapped facets}
\usage{
facet_wrap2(
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  axes = "margins",
  remove_labels = "none",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  drop = TRUE,
  dir = "h",
  strip.position = "top"
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{nrow}{Number of rows and columns.}

\item{ncol}{Number of rows and columns.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{axes}{A \code{character} where axes should be drawn. Either
\code{"margins"} (default), \code{"rows"}, \code{"cols"} or \code{"full"}.
Only applies when the scale is free through the \code{scales} argument.}

\item{remove_labels}{A \code{character} denoting what labels should be
removed when axes are repeated and redundant. Either \code{"none"}
(default), \code{"rows"}, \code{"cols"} or \code{"all"}. Only applies to
relevant position guides included with the \code{axes} argument when scales
are fixed.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either \code{"h"} for horizontal, the default, or \code{"v"},
for vertical.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\value{
A \code{Facet} ggproto object that can be added to a plot.
}
\description{
This function behaves like \code{\link[ggplot2]{facet_wrap}()}, but has a few
extra options on axis drawing when scales are fixed.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) + geom_point()

# Repeat all axes for every facet
p + facet_wrap2(vars(class), axes = "full")

# Repeat only y-axes
p + facet_wrap2(vars(class), axes = "cols")

# Repeat axes without labels
p + facet_wrap2(vars(class), axes = "full", remove_labels = "all")

# Repeat axes without x-axis labels
p + facet_wrap2(vars(class), axes = "full", remove_labels = "rows")
}
\seealso{
Other facetting functions: 
\code{\link{facet_nested_wrap}()},
\code{\link{facet_nested}()}
}
\concept{facetting functions}
