% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghost.R
\name{summary.ggghost}
\alias{summary.ggghost}
\title{List the calls contained in a ggghost object}
\usage{
\method{summary}{ggghost}(object, ...)
}
\arguments{
\item{object}{A ggghost object to present}

\item{...}{Mainly provided for \code{summary.default} generic consistency.
When \code{combine} is passed as an argument (arbitrary value) the list of
calls is concatenated into a single string as one might write the ggplot
call.}
}
\value{
Either a list of ggplot calls or a string of such concatenated with " + "
}
\description{
Summarises a ggghost object by presenting the contained calls in the order
they were added. Optionally concatenates these into a single ggplot call.
}
\details{
The data is also included in ggghost objects. If this is also
desired in the output, use \code{str}. See example.
}
\examples{
## present the ggghost object as a list
tmpdata <- data.frame(x = 1:100, y = rnorm(100))

z \%g<\% ggplot(tmpdata, aes(x,y))
z <- z + geom_point(col = "steelblue")
summary(z)

## present the ggghost object as a string
summary(z, combine = TRUE) # Note, value of 'combine' is arbitrary

## to inspect the data structure also captured, use str()
str(z)
}
