% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion_blur.R
\name{with_motion_blur}
\alias{with_motion_blur}
\title{Apply a motion blur to your layer}
\usage{
with_motion_blur(x, sigma = 0.5, angle = 0, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{sigma}{The standard deviation of the gaussian kernel. Increase it to
apply more blurring. If a numeric it will be interpreted as given in pixels.
If a unit object it will automatically be converted to pixels at rendering
time}

\item{angle}{Direction of the movement in degrees (0 corresponds to a
left-to-right motion and the angles move in clockwise direction)}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter adds a directional blur to the provided ggplot layer. The amount
of blur, as well as the angle, can be controlled.
}
\examples{
\dontshow{if (!ggfx:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
ggplot(mtcars, aes(mpg, disp)) +
  with_motion_blur(
    geom_point(size = 3),
    sigma = 6,
    angle = -45
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other blur filters: 
\code{\link{with_blur}()},
\code{\link{with_variable_blur}()}
}
\concept{blur filters}
