% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dither.R
\name{with_dither}
\alias{with_dither}
\title{Dither image using Floyd-Steinberg error correction dithering}
\usage{
with_dither(x, max_colours = 256, colourspace = "sRGB", ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{max_colours}{The maximum number of colours to use. The result may
contain fewer colours but never more.}

\item{colourspace}{In which colourspace should the dithering be calculated}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter reduces the number of colours in your layer and uses the
Floyd-Steinberg algorithm to even out the error introduced by the colour
reduction.
}
\examples{
library(ggplot2)
ggplot(faithfuld, aes(waiting, eruptions)) +
  with_dither(
    geom_raster(aes(fill = density), interpolate = TRUE),
    max_colours = 10
  ) +
  scale_fill_continuous(type = 'viridis')

}
\seealso{
Other dithering filters: 
\code{\link{with_circle_dither}()}
}
\concept{dithering filters}
