% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggridges.R
\name{gf_ridgeline}
\alias{gf_ridgeline}
\alias{gf_density_ridges}
\alias{gf_density_ridges2}
\alias{gf_density_ridgeline_gradient}
\alias{gf_density_ridges_gradient}
\title{Formula interface to ggridges plots}
\usage{
gf_ridgeline(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  height,
  scale = 1,
  min_height = 0,
  color,
  fill,
  alpha,
  group,
  linetype,
  linewidth,
  point_size,
  point_shape,
  point_colour,
  point_fill,
  point_alpha,
  point_stroke,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "ridgeline",
  stat = "identity",
  position = "identity",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)

gf_density_ridges(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  height,
  scale = 1,
  rel_min_height = 0,
  color,
  fill,
  alpha,
  group,
  linetype,
  linewidth,
  point_size,
  point_shape,
  point_colour,
  point_fill,
  point_alpha,
  point_stroke,
  panel_scaling = TRUE,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "density_ridges",
  stat = "density_ridges",
  position = "points_sina",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)

gf_density_ridges2(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  height,
  scale = 1,
  rel_min_height = 0,
  color,
  fill,
  alpha,
  group,
  linetype,
  linewidth,
  point_size,
  point_shape,
  point_colour,
  point_fill,
  point_alpha,
  point_stroke,
  panel_scaling = TRUE,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "density_ridges2",
  stat = "density_ridges",
  position = "points_sina",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)

gf_density_ridgeline_gradient(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  height,
  color,
  fill,
  alpha,
  group,
  linetype,
  linewidth,
  gradient_lwd = 0.5,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "ridgeline_gradient",
  stat = "identity",
  position = "identity",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)

gf_density_ridges_gradient(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  height,
  panel_scaling = TRUE,
  color,
  fill = ~stat(x),
  alpha,
  group,
  linetype,
  linewidth,
  gradient_lwd = 0.5,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "density_ridges_gradient",
  stat = "density_ridges",
  position = "points_sina",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{height}{The height of each ridgeline at the respective x value.
Automatically calculated and provided by \code{\link[ggridges:stat_density_ridges]{ggridges::stat_density_ridges()}}
if the default stat is not changed.}

\item{scale}{A scaling factor to scale the height of the ridgelines relative to the
spacing between them. A value of 1 indicates that the maximum point of any ridgeline touches the baseline right above, assuming even spacing between baselines.}

\item{min_height}{A height cutoff on the drawn ridgelines. All values that fall below
this cutoff will be removed. The main purpose of this cutoff is to remove
long tails right at the baseline level, but other uses are possible. The
cutoff is applied before any height scaling is applied via the scale
aesthetic. Default is 0, so negative values are removed.}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{linewidth}{A numerical line width or a formula used for mapping linewidth.}

\item{point_shape, point_colour, point_size, point_fill, point_alpha, point_stroke}{As in \code{\link[ggridges:geom_ridgeline]{ggridges::geom_ridgeline()}}.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title, subtitle, caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_density()} and \code{stat_density()}.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{rel_min_height}{Lines with heights below this cutoff will be removed. The cutoff is
measured relative to the overall maximum, so \code{rel_min_height = 0.01} would
remove everything. Default is 0, so nothing is removed.}

\item{panel_scaling}{If \code{TRUE}, the default, relative scaling is calculated separately
for each panel. If \code{FALSE}, relative scaling is calculated globally.}

\item{gradient_lwd}{A parameter to needed to remove rendering artifacts inside the
rendered gradients. Should ideally be 0, but often needs to be around 0.5 or higher.}
}
\description{
Formula interface to ggridges plots
}
\section{Details}{

Note that the \code{\link[ggridges:stat_density_ridges]{ggridges::stat_density_ridges()}} makes joint density estimation
across all datasets. This may not generate the desired result when using
faceted plots. As an alternative, you can set \code{stat = "density"} to use
\code{\link[ggplot2:geom_density]{ggplot2::stat_density()}}. In this case, it is required to add the aesthetic mapping
\code{height = after_stat(density)} (see examples).
}

\examples{
data.frame(
  x = rep(1:5, 3), y = c(rep(0, 5), rep(1, 5), rep(3, 5)),
  height = c(0, 1, 3, 4, 0, 1, 2, 3, 5, 4, 0, 5, 4, 4, 1)
) |>
  gf_ridgeline(y ~ x, height = ~ height, group = ~y, fill = "lightblue", alpha = 0.7)
diamonds |>
  gf_density_ridges(cut ~ price,
    scale = 2, fill = ~ cut, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
diamonds |>
  gf_density_ridges(clarity ~ price | cut,
    scale = 2, fill = ~ clarity, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
\dontrun{
diamonds |>
  gf_density_ridges(clarity ~ price | cut, height = ~after_stat(density), stat = "density",
    scale = 2, fill = ~ clarity, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
}
\dontrun{
diamonds |>
  gf_density_ridges2(cut ~ price, scale = 2, fill = ~ cut, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
}
diamonds |>
  gf_density_ridges(cut ~ price,
    scale = 2, fill = ~ cut, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
diamonds |>
  gf_density_ridges(clarity ~ price | cut,
    scale = 2, fill = ~ clarity, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
\dontrun{
diamonds |>
  gf_density_ridges(clarity ~ price | cut, height = ~ after_stat(density), stat = "density",
    scale = 2, fill = ~ clarity, alpha = 0.6, show.legend = FALSE) |>
  gf_theme(theme_ridges()) |>
  gf_refine(
    scale_y_discrete(expand = c(0.01, 0)),
    scale_x_continuous(expand = c(0.01, 0))
  )
}
\dontrun{
mosaicData::Weather |>
  gf_density_ridges_gradient(month ~ high_temp | city ~ ., fill = ~stat(x),
    group = ~ month, show.legend = FALSE, rel_min_height = 0.02) |>
  gf_refine(scale_fill_viridis_c(option = "B"), theme_bw())
}
}
\seealso{
\code{\link[ggridges:geom_density_ridges]{ggridges::geom_density_ridges()}}

\code{\link[ggridges:geom_ridgeline]{ggridges::geom_ridgeline()}}

\code{\link[ggridges:geom_ridgeline_gradient]{ggridges::geom_density_ridges_gradient()}}
}
