% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel.R
\name{var_label}
\alias{var_label}
\alias{var_label<-}
\alias{get_variable_labels}
\alias{set_variable_labels}
\title{Set and extract labels from a labeled object}
\usage{
var_label(x, unlist = FALSE)

var_label(x) <- value

get_variable_labels(x, unlist = FALSE)

var_label(x, unlist = FALSE)

set_variable_labels(.data, ..., .labels = NA, .strict = TRUE)
}
\arguments{
\item{x}{a vector or a data.frame}

\item{unlist}{for data frames, return a named vector instead of a list}

\item{value}{a character string or \code{NULL} to remove the label
For data frames, it could also be a named list or a character vector
of same length as the number of columns in \code{x}.}

\item{.data}{a data frame}

\item{...}{name-value pairs of variable labels (see examples)}

\item{.labels}{variable labels to be applied to the data.frame,
using the same syntax as \code{value} in \code{var_label(df) <- value}.}

\item{.strict}{should an error be returned if some labels
doesn't correspond to a column of \code{x}?}
}
\value{
\code{set_variable_labels()} will return an updated copy of \code{.data}.
}
\description{
Some packages like expss provide mechanisms for providing longer labels to R objects.
These labels can be used when labeling plots and tables, for example, without requiring
long or awkward variable names.  This is an experimental feature and currently only supports
expss or any other system that stores a label in the \code{label} attribute of a vector.
}
\details{
For data frames, if \code{value} is a named list, only elements whose name will
match a column of the data frame will be taken into account. If \code{value}
is a character vector, labels should in the same order as the columns of the
data.frame.
}
\note{
These functions are imported from the \code{{labelled}} package.
}
\examples{
KF <-
  mosaicData::KidsFeet \%>\%
  set_variable_labels(
      length      = 'foot length (cm)',
      width       = 'foot width (cm)',
      birthmonth  = 'birth month',
      birthyear   = 'birth year',
      biggerfoot  = 'bigger foot',
      domhand     = 'dominant hand'
  )
KF \%>\%
  gf_point(length ~ width, color = ~ domhand)
get_variable_labels(KF)
}
