% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotDegMatrix}
\alias{plotDegMatrix}
\title{Returns the image object to show the heat map of degrees between the inputted set of vertices}
\usage{
plotDegMatrix(varieties, ig, geneal)
}
\arguments{
\item{varieties}{subset of varieties used to generate the heat map}

\item{ig}{the graph representation of the data genealogy (in igraph format)}

\item{geneal}{the full genealogy  (in data frame format)}
}
\description{
Returns the image object to show the heat map of degrees between the inputted set of vertices
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
varieties <- c("Bedford", "Calland", "Narow", "Pella", "Tokyo", "Young", "Zane")
p <- plotDegMatrix(varieties, ig, sbGeneal)
p + ggplot2::scale_fill_continuous(low = "white", high = "darkgreen")
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
\seealso{
\url{https://www.r-project.org} for iGraph information
}
