% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotPath}
\alias{plotPath}
\title{Construct the graphic object of the path}
\usage{
plotPath(path)
}
\arguments{
  \item{path}{object created from function getPath}
}
\description{
This function takes the path as input and outputs an
ggplot2 object. The image will correctly position the node
labels with x-axis representing the node year, and y-axis
representing the node path index. Edges between two nodes
represent parent-child relationships between those nodes.
For visual appeal, there is a grey box that outlines the
node label, as well as an underline and overline for each
label.
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
p <- getPath("Brim","Bedford",ig,sbGeneal)
plotPath(p)
}
\seealso{
\code{\link{getPath}} for information on input path
building
}

