% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{summary.model}
\alias{summary.model}
\title{Summarise posterior samples}
\usage{
\method{summary}{model}(object, hyper = FALSE, start = 1, end = NA,
  hmeans = FALSE, hci = FALSE, prob = c(0.025, 0.25, 0.5, 0.75,
  0.975), recovery = FALSE, ps = NA, type = 1, verbose = FALSE,
  digits = 2, ...)
}
\arguments{
\item{object}{posterior samples}

\item{hyper}{whether to summarise hyper parameters}

\item{start}{summarise from which iteration.}

\item{end}{summarise to the end which iteration. For example, set
\code{start = 101} and \code{end = 1000}, instructs the function to
calculate from 101 to 1000 iteration.}

\item{hmeans}{a boolean switch indicating to calculate mean of hyper
parameters}

\item{hci}{boolean switch indicating to calculate credible intervals of
hyper parameters}

\item{prob}{a numeric vector, indicating the quantiles to calculate}

\item{recovery}{a boolean switch indicating if samples are from a recovery
study}

\item{ps}{true parameter values.  This is only for recovery studies}

\item{type}{calculate type 1 or 2 hyper parameters}

\item{verbose}{print more information}

\item{digits}{printing digits}

\item{...}{other arguments}
}
\description{
This calls severn different variants of summary function to summarise
posterior samples
}
\examples{
\dontrun{
est1 <- summary(hsam[[1]], FALSE)
est2 <- summary(hsam[[1]], FALSE, 1, 100)
est3 <- summary_one(hsam[[1]], 1, 100, c(.025, .5, .975), verbose = TRUE)
est4 <- summary_one(hsam[[1]], 1, 100, c(.025, .5, .975), verbose = F)

est5 <- summary_many(hsam, 1, 100, c(.025, .5, .975), FALSE)
est6 <- summary_many(hsam, 1, 100, c(.025, .5, .975), TRUE)
est7 <- summary(hsam)
est8 <- summary(hsam, verbose = TRUE)
est9 <- summary(hsam, verbose = FALSE)


hest1 <- summary_hyper(hsam, 1, 100, F, F, c(.025, .5, .975), 2, F)
hest2 <- summary_hyper(hsam, 1, 100, F, F, c(.05, .5, .9), 2, F)
hest3 <- summary(hsam, TRUE)
}
}
