% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_eam.R
\name{likelihood}
\alias{likelihood}
\alias{likelihood.default}
\alias{likelihood.norm}
\alias{likelihood.rd}
\title{Calculate Log-Likelihood}
\usage{
likelihood(data, p.vector, min.like = 1e-10, ...)

\method{likelihood}{default}(data, p.vector, min.like = 1e-10, ...)

\method{likelihood}{rd}(data, p.vector, min.like = 1e-10, ...)

\method{likelihood}{norm}(data, p.vector, min.like = 1e-10, ...)
}
\arguments{
\item{data}{a model data instance}

\item{p.vector}{a parameter vector}

\item{min.like}{minimal likelihood, 1e-10}

\item{...}{other parameters, such as \emph{precision} for \code{ddm},
\emph{ok.types} for \code{lba_B}.}
}
\value{
a vector of likelihoods for each RT in data (in same order)
}
\description{
\code{likelihood.rd} is a legacy function for computing diffusion
model density. If the speed of computation is a concern, the user may want to
use \code{ddmc}, which implemnts a streamlined C++ diffusion model density.
}
\keyword{likelihood}

