% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_keep_seq.R
\name{str_keep_seq}
\alias{str_keep_seq}
\title{Keep elements in a vector sequence, and replace the rest with ""}
\usage{
str_keep_seq(x, by = 2, offset = 0, ...)
}
\arguments{
\item{x}{A vector.}

\item{by}{The increment of elements to keep. Defaults to 2.}

\item{offset}{An offset to start at the intended offset. Defaults to 0. Possible values are -1 to (\code{by} - 2)}

\item{...}{If numeric, other arguments passed to the scales::comma function.}
}
\value{
A vector.
}
\description{
Keep elements in a vector sequence, and replace the rest with ""
}
\examples{
x <- LETTERS[1:12]
str_keep_seq(x)
str_keep_seq(x, offset = -1)
str_keep_seq(x, by = 3)
str_keep_seq(x, by = 3, offset = -1)
str_keep_seq(x, by = 3, offset = 1)

y <- c(1000, 2000, 3000)
str_keep_seq(y)
str_keep_seq(y, big.mark = " ")

z <- c(0.0, 0.25, 0.5, 0.75, 1)
str_keep_seq(z)
str_keep_seq(z, drop0trailing = TRUE)

str_keep_seq(format(ggplot2::economics$date[1:6], "\%Y-\%m"))

library(palmerpenguins)
penguins |>
 gg_jitter(x = species,
           y = body_mass_g,
           col = flipper_length_mm,
           facet = island,
           facet2 = species,
           y_breaks = scales::breaks_pretty(n = 10),
           y_labels = \(x) str_keep_seq(x, by = 2),
           x_labels = \(x) str_keep_seq(x, by = 2),
           col_labels = \(x) str_keep_seq(x, by = 2, offset = -1))

}
