% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal.R
\docType{data}
\name{pal_discrete2}
\alias{pal_discrete2}
\title{A colour blind safe categorical palette with 6 colours}
\format{
An object of class \code{character} of length 6.
}
\usage{
pal_discrete2
}
\value{
A character vector of hex codes.
}
\description{
A colour blind safe 6 colour palette used to colour a categorical col variable that works only on a light background.
}
\examples{
scales::show_col(pal_discrete2)

ggplot2::diamonds |>
  gg_bar(x = color,
         col = color,
         pal = pal_discrete2,
         width = 0.75)

ggplot2::diamonds |>
  gg_blank(x = color,
           col = color,
           stat = "count",
           pal = pal_discrete2) +
  ggplot2::geom_point(stat = "count")

}
\references{
Derived from a Datawrapper blog dated 30/03/2022 by Lisa Charlotte Muth.
}
\keyword{datasets}
