% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal.R
\docType{data}
\name{pal_discrete}
\alias{pal_discrete}
\title{Default colour blind safe categorical palette with 5 colours}
\format{
An object of class \code{character} of length 5.
}
\usage{
pal_discrete
}
\value{
A character vector of hex codes.
}
\description{
The default colour blind safe 5 colour palette used to colour a categorical col variable.
}
\examples{
scales::show_col(pal_discrete)

ggplot2::diamonds |>
  gg_bar(x = color,
         col = color,
         pal = pal_discrete,
         width = 0.75)

ggplot2::diamonds |>
  gg_blank(x = color,
           col = color,
           stat = "count",
           pal = pal_discrete) +
  ggplot2::geom_point(stat = "count")

ggplot2::diamonds |>
  gg_blank(x = color,
           col = color,
           stat = "count",
           pal = pal_discrete,
           theme = dark_mode()) +
  ggplot2::geom_point(stat = "count")

}
\references{
Derived from a Datawrapper blog dated 30/03/2022 by Lisa Charlotte Muth.
}
\keyword{datasets}
