% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-reorder.R
\name{align_reorder}
\alias{align_reorder}
\title{Reorders layout observations based on weights or summary statistics.}
\usage{
align_reorder(
  fun = rowMeans,
  ...,
  strict = TRUE,
  decreasing = FALSE,
  data = NULL,
  set_context = FALSE,
  name = NULL
)
}
\arguments{
\item{fun}{A summary function. It should take a data and return the weights
for the layout observations.}

\item{...}{Additional arguments passed to \code{fun}.}

\item{strict}{A boolean value indicates whether the order should be strict.
If previous groups has been established, and strict is \code{FALSE}, this will
reorder the observations in each group.}

\item{decreasing}{A boolean value. Should the sort order be increasing or
decreasing?}

\item{data}{A matrix, a data frame, or even a simple vector that will be
converted into a one-column matrix. If the \code{data} argument is set to \code{NULL},
the \verb{align_*} will use the \code{layout} data. Additionally, the \code{data} argument
can also accept a function (purrr-like lambda is also okay), which will be
applied with the \code{layout} data,

It is important to note that all \verb{align_*} functions consider the \code{rows} as
the observations. It means the \code{NROW(data)} must return the same number with
the parallel \code{layout} axis.
\itemize{
\item \code{layout_heatmap}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{layout_stack}: the \code{layout} data will be used as it is since we place all
plots along a single axis.
}}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Reorders layout observations based on weights or summary statistics.
}
\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("l") +
    align_reorder()
}
