% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.gg_survival.R
\name{plot.gg_survival}
\alias{plot.gg_survival}
\title{Plot a \code{\link{gg_survival}}  object.}
\usage{
\method{plot}{gg_survival}(x, type = c("surv", "cum_haz", "hazard", "density",
  "mid_int", "life", "proplife"), error = c("shade", "bars", "lines", "none"),
  ...)
}
\arguments{
\item{x}{\code{\link{gg_survival}} or a survival \code{\link{gg_rfsrc}} object created from a
\code{randomForestSRC::rfsrc} object}

\item{type}{"surv", "cum_haz","hazard","density","mid_int", "life","proplife"}

\item{error}{"shade", "bars", "lines" or "none"}

\item{...}{not used}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_survival}}  object.
}
\examples{
\dontrun{
## -------- pbc data
data(pbc, package="randomForestSRC")
pbc$time <- pbc$days/364.25

# This is the same as kaplan
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc)

plot(gg_dta, error="none")
plot(gg_dta)

# Stratified on treatment variable.
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc, by="treatment")

plot(gg_dta, error="none")
plot(gg_dta)

# ...with smaller confidence limits.
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc, by="treatment", conf.int=.68)

plot(gg_dta, error="lines")

}
}

