% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_rfsrc.R
\name{gg_rfsrc.rfsrc}
\alias{gg_rfsrc}
\alias{gg_rfsrc.rfsrc}
\title{Predicted response data object}
\usage{
gg_rfsrc.rfsrc(object, oob = TRUE, by, ...)
}
\arguments{
\item{object}{\code{randomForestSRC::rfsrc} object}

\item{oob}{boolean, should we return the oob prediction , or the full
forest prediction.}

\item{by}{stratifying variable in the training dataset, defaults to NULL}

\item{...}{extra arguments}
}
\value{
\code{gg_rfsrc} object
}
\description{
Extracts the predicted response values from the \code{randomForestSRC::rfsrc} object,
and formats data for plotting the response using \code{\link{plot.gg_rfsrc}}.
}
\details{
\code{surv_type} ("surv", "chf", "mortality", "hazard") for survival forests

   \code{oob} boolean, should we return the oob prediction , or the full
forest prediction.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## -------- iris data
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris, package="ggRandomForests")
gg_dta<- gg_rfsrc(rfsrc_iris)

plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
\dontrun{
## -------- air quality data
# rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
data(rfsrc_airq, package="ggRandomForests")
gg_dta<- gg_rfsrc(rfsrc_airq)

plot(gg_dta)
}

## -------- Boston data
data(rfsrc_Boston, package="ggRandomForests")
plot(rfsrc_Boston)

\dontrun{
## -------- mtcars data
data(rfsrc_mtcars, package="ggRandomForests")
gg_dta<- gg_rfsrc(rfsrc_mtcars)

plot(gg_dta)
}
## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
\dontrun{
## -------- veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
data(rfsrc_veteran, package = "ggRandomForests")
gg_dta <- gg_rfsrc(rfsrc_veteran)
plot(gg_dta)

gg_dta <- gg_rfsrc(rfsrc_veteran, conf.int=.95)
plot(gg_dta)

gg_dta <- gg_rfsrc(rfsrc_veteran, by="trt")
plot(gg_dta)
}

## -------- pbc data
## We don't run this because of bootstrap confidence limits
data(rfsrc_pbc, package = "ggRandomForests")

\dontrun{
gg_dta <- gg_rfsrc(rfsrc_pbc)
plot(gg_dta)

gg_dta <- gg_rfsrc(rfsrc_pbc, conf.int=.95)
plot(gg_dta)
}

gg_dta <- gg_rfsrc(rfsrc_pbc, by="treatment")
plot(gg_dta)
}
\seealso{
\code{\link{plot.gg_rfsrc}} \code{rfsrc} \code{plot.rfsrc} \code{\link{gg_survival}}
}

