% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/print.gg_interaction.R
\name{print.gg_interaction}
\alias{print.gg_interaction}
\title{Print a \code{\link{gg_interaction}} object.}
\usage{
\method{print}{gg_interaction}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_interaction}} object.}

\item{...}{optional arguments

We use the tble_df command to print \code{gg_interaction} objects because they
tend to be long (ntree records long).}
}
\description{
Print a \code{\link{gg_interaction}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# interaction_iris <- find.interaction(rfsrc_iris)
#
# ... or load a cached randomForestSRC object
data(interaction_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_interaction(interaction_iris)
print(gg_dta)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
data(interaction_airq, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_interaction(interaction_airq)
print(gg_dta)
}
\seealso{
\code{rfsrc} \code{tbl_df} \code{\link{gg_interaction}}
}

