% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.gg_variable.R
\name{plot.gg_variable}
\alias{plot.gg_variable}
\title{Plot a \code{\link{gg_variable}} object,}
\usage{
\method{plot}{gg_variable}(x, xvar, time, time_labels, panel = FALSE,
  oob = TRUE, smooth = TRUE, ...)
}
\arguments{
\item{x}{\code{\link{gg_variable}} object created from a \code{randomForestSRC::rfsrc} object}

\item{xvar}{variable (or list of variables) of interest.}

\item{time}{For survival, one or more times of interest}

\item{time_labels}{string labels for times}

\item{panel}{Should plots be facetted along multiple xvar?}

\item{oob}{oob estimates (boolean)}

\item{smooth}{type of smooth curve}

\item{...}{arguments passed to the \code{\link{gg_variable}} function.}
}
\value{
A single \code{ggplot} object, or list of \code{ggplot} objects
}
\description{
Plot a \code{\link{gg_variable}} object,
}
\examples{
\dontrun{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris
#iris.obj <- rfsrc(Species ~., data = iris)
data(iris_rf, package="ggRandomForests")


## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality
#airq.obj <- rfsrc(Ozone ~ ., data = airquality)
data(airq_rf, package="ggRandomForests")
gg_dta <- gg_variable(airq_rf)
plot(gg_dta, xvar="Wind")
plot(gg_dta, xvar="Temp")
plot(gg_dta, xvar="Solar.R")

## motor trend cars
#mtcars.obj <- rfsrc(mpg ~ ., data = mtcars)
data(mtcars_rf, package="ggRandomForests")
gg_dta <- gg_variable(mtcars_rf)

# mtcars$cyl is an ordinal variable
plot(gg_dta, xvar="cyl")

# Others are continuous
plot(gg_dta, xvar="disp")
plot(gg_dta, xvar="hp")
plot(gg_dta, xvar="wt")

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------

## survival
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
data(veteran_rf, package="ggRandomForests")

# get the 30 day survival time.
gg_dta <- gg_variable(veteran_rf, time=30)

# Generate variable dependance plots for age and diagtime
plot(gg_dta, xvar = "age")
plot(gg_dta, xvar = "diagtime")

# If we want to compare survival at different time points, say 30, 90 day
# and 1 year
gg_dta <- gg_variable(veteran_rf, time=c(30, 90, 365))

# Generate variable dependance plots for age and diagtime
plot(gg_dta, xvar = "age")
plot(gg_dta, xvar = "diagtime")

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R, Rnews,
7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, Regression
and Classification (RF-SRC), R package version 1.4.
}

