% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_Summay_FUNs.R
\name{QC_Lines}
\alias{QC_Lines}
\title{Calculate QC Limits}
\usage{
QC_Lines(data = NULL, value = NULL, grouping = NULL,
  formula = NULL, n = NULL, method = "xBar.rBar", na.rm = FALSE)
}
\arguments{
\item{data}{vector or dataframe, as indicated below for each chart type
\itemize{
\item \bold{Individuals & Attribute Charts}: vector of values;
\item \bold{Studentized & Dispersion Charts}: dataframe
}}

\item{value}{string, \bold{Studentized Charts} and \bold{Dispersion Charts}, numeric vector in dataframe with values of interest}

\item{grouping}{string, \bold{Studentized Charts} and \bold{Dispersion Charts}: single factor/variable to split
the dataframe "values" by}

\item{formula}{\bold{Studentized Charts} and \bold{Dispersion Charts}: a formula,
such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}

\item{n}{number or vector as indicated below for each chart type.
\itemize{
\item \bold{Individuals Charts}: No effect
\item \bold{Attribute Charts}: (p and u) vector, indicating sample area of opportunity.
\item \bold{Attribute Charts}: (np) number, indicating constant sampling area of opportunity.
\item \bold{Studentized Charts}: number, user specified subgroup size.
\item \bold{Dispersion Charts}: No effect
}}

\item{method}{string, calling the following methods:
\itemize{
\item \bold{Individuals Charts}: mR, XmR,
\item \bold{Attribute Charts}: c, np, p, u,
\item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian
\item \bold{Dispersion Charts}: rBar, rMedian, sBar.
}}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}
}
\value{
a dataframe,
\itemize{
\item \bold{Attribute Data:} (p and u) Center Line, Upper Control Limit and Lower Control limit for each point.
\item \bold{Other Data}: single line dataframe, with relevant control limits noted in column headings.
}
}
\description{
Calculates QC chart lines for the following chart types and reports in a dataframe:
\itemize{
\item \bold{Individuals Charts}: mR, XmR,
\item \bold{Attribute Charts}: c, np, p, u,
\item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian,
\item \bold{Dispersion Charts}: rBar, rMedian, sBar.
}
}
\note{
If using the \bold{formula} argument do not use \bold{value} and \bold{group} arguments.
}
\examples{
#############################################
#  Example 1: Charts other than "p" or "u"  #
#############################################

# Load Libraries ----------------------------------------------------------
 require(ggQC)
 require(plyr)
 require(ggplot2)

# Setup Data --------------------------------------------------------------
 set.seed(5555)
 Process1 <- data.frame(processID = as.factor(rep(1,100)),
                        metric_value = rnorm(100,0,1),
                        subgroup_sample=rep(1:20, each=5),
                        Process_run_id = 1:100)
 set.seed(5555)
 Process2 <- data.frame(processID = as.factor(rep(2,100)),
                        metric_value = rnorm(100,5, 1),
                        subgroup_sample=rep(1:10, each=10),
                        Process_run_id = 101:200)

 Both_Processes <- rbind(Process1, Process2)

# QC Values For Individuals -----------------------------------------------
 # All Together
   QC_Lines(data = Both_Processes$metric_value, method = "XmR")


 # For Each Process
   ddply(Both_Processes, .variables = "processID",
     .fun =function(df){
       QC_Lines(data = df$metric_value, method = "XmR")
     }
   )

# QC Values For Studentized Runs-------------------------------------------
 # All Together
   QC_Lines(data = Both_Processes,
        formula = metric_value ~ subgroup_sample)


 # For Each Process
   ddply(Both_Processes, .variables = "processID",
     .fun =function(df){
       QC_Lines(data = df, formula = metric_value ~ subgroup_sample)
     }
   )


########################
#  Example 2 "p" data  #
########################

# Setup p Data ------------------------------------------------------------
 set.seed(5555)
 bin_data <- data.frame(
   trial = 1:30,
   Num_Incomplete_Items = rpois(n = 30, lambda = 30),
   Num_Items_in_Set = runif(n = 30, min = 50, max = 100))

 bin_data$Proportion_Incomplete <- bin_data$Num_Incomplete_Items/bin_data$Num_Items_in_Set

# QC_Lines for "p" data ---------------------------------------------------
 QC_Lines(data = bin_data$Proportion_Incomplete,
        n = bin_data$Num_Items_in_Set, method="p")


########################
#  Example 3 "u" data  #
########################

# Setup u Data ------------------------------------------------------------
 set.seed(5555)
 bin_data <- data.frame(
   trial=1:30,
   Num_of_Blemishes = rpois(n = 30, lambda = 30),
   Num_Items_Inspected = runif(n = 30, min = 50, max = 100))

 bin_data$Blemish_Rate <- bin_data$Num_of_Blemishes/bin_data$Num_Items_Inspected


# QC Lines for "u" data ---------------------------------------------------
 QC_Lines(data = bin_data$Blemish_Rate,
        n = bin_data$Num_Items_Inspected, method="u")
}
\references{
Wheeler, DJ, and DS Chambers. Understanding Statistical Process Control, 2nd Ed. Knoxville, TN: SPC, 1992. Print.
}
