% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisons.R
\name{rmse_calculate}
\alias{rmse_calculate}
\title{Calculate RMSE for Covariate, Outcome, and Competing Risk Models}
\usage{
rmse_calculate(
  i,
  fits,
  covnames,
  covtypes,
  obs_data,
  outcome_name,
  time_name,
  restrictions,
  yrestrictions,
  compevent_restrictions
)
}
\arguments{
\item{i}{Integer specifying the index of \code{fits}.}

\item{fits}{List of fitted models.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{obs_data}{Data table containing the observed data.}

\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{restrictions}{List of vectors. Each vector contains as its first entry a covariate for which
\emph{a priori} knowledge of its distribution is available; its second entry a condition
under which no knowledge of its distribution is available and that must be \code{TRUE}
for the distribution of that covariate given that condition to be estimated via a parametric
model or other fitting procedure; its third entry a function for estimating the distribution
of that covariate given the condition in the second entry is false such that \emph{a priori} knowledge
of the covariate distribution is available; and its fourth entry a value used by the function in the
third entry. The default is \code{NA}.}

\item{yrestrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the outcome variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the outcome variable takes on the value in the second entry.}

\item{compevent_restrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the competing event variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the competing event variable takes on the value in the
second entry.}
}
\value{
The RMSE for the model.
}
\description{
This internal function calculates root mean square error (RMSE) for the covariate (and the outcome and competing event, if applicable) models fit on
the observed data.
}
\keyword{internal}
