% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiCDF}
\alias{gfiCDF}
\title{Fiducial cumulative distribution function}
\usage{
gfiCDF(parameter, fidsamples)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest}

\item{fidsamples}{fiducial samples, the output of \code{\link{gfilinreg}} or 
\code{\link{gfilinregPredictive}}}
}
\value{
The fiducial cumulative distribution function of the parameter.
}
\description{
Fiducial cumulative distribution function of a parameter of 
  interest.
}
\examples{
set.seed(666L)
dat <- data.frame(
  group = gl(2, 15), 
  y = c(2*rlogis(15L), 10 + 2*rlogis(15L))
)
gfi <- gfilinreg(y ~ 0 + group, distr = "logistic", data = dat, L = 30L)
fcdf <- gfiCDF(~ group1 - group2, gfi)
fcdf(0)
plot(fcdf)
}
