% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIndex.R
\name{getIndex}
\alias{getIndex}
\title{get a company's market cap, data comes from NetEase}
\usage{
getIndex(tickers, indexData)
}
\arguments{
\item{tickers}{ticker/sympol of a company, MUST BE A CHARACTER, e.g., input "006600" instead of 006600
The tickers have to be FULL AND EXACT, e.g., for Shanghai exchange and Shenzhen exchange, the input must have 6 digits, and for HK exchange, it must
have 5 digits. the '0' in the beginning cannot be left out.}

\item{indexData}{the index information, before running getIndex, indexData needs to be loaded using \code{\link{getIndexData}}}
}
\value{
A data table with companies and which index they are included
}
\description{
get a company's market cap, data comes from NetEase
}
\details{
Data comes from www.finance.sina.com.cn and www.etnet.com.hk
}
\examples{
\dontrun{
indexData <- getIndexData()
getIndex(600601, indexData)
}
}
\references{
www.finance.sina.com.cn
www.etnet.com.hk
}
