% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeakRankNorm.R
\name{WeakRankNorm}
\alias{WeakRankNorm}
\title{Weak ranking family (normalized)}
\usage{
WeakRankNorm(K)
}
\arguments{
\item{K}{Indicates that we are only interesting in the top \eqn{K} instances. Must be an integer between 1 and the number
\eqn{n} of observations.}
}
\value{
A Boosting family object
}
\description{
{Gradient-free Gradient Boosting family for the normalized weak ranking loss function.}
}
\details{
{A more intuitive loss function than the weak ranking loss thanks to its normalization to a maximum value
of 1. For example, if a number \eqn{c} of the top \eqn{K} instances has not been ranked at the top of the list, the
normalized weak ranking loss is \eqn{C/K}. \code{WeakRankNorm} returns a family object as in the package \code{mboost}.}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020,
Remark (5.2.4)}

{T. Hothorn, P. Bühlmann, T. Kneib, M. Schmid, and B. Hofner. mboost: Model-Based
Boosting, 2017}
}
